<?php
    /**
    *
    * copyright (c) 2013-2019 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    class VisualizzatoreContatore extends VisualizzatoreComponente {
        function __construct($db) {
            parent::__construct($db);
        }

        function generaContenutoSezione($dati) {
            $datiContatore = parent::getDb()->leggiSingolaRiga("geec_contatori",$dati["idElemento"]);
            
            echo"<div class=\"{$datiContatore["spazioOccupato"]}\">
                    <div class=\"row\">";
                    $this->stampaElementiContatore($dati);
                echo"</div>
                </div>";
        }
        
        function stampaElementiContatore($dati) {
            $query = "SELECT * FROM geec_elementiContatore WHERE idContatore = {$dati["idElemento"]} ORDER BY posizione ASC";
            $ris   = parent::getDb()->eseguiQueryLettura($query);

            while($elemento = $ris->fetch_assoc()) {
                $classeColore = "text-".strtolower($elemento["colore"]);
                echo"<div class=\"col-sm-3 text-center mx-auto\">
                        <i class=\"{$elemento["icona"]} fa-{$elemento["dimensioneIcona"]} mb-2 $classeColore\"></i>
                        <h3 class=\"$classeColore\"><span class=\"counter\">{$elemento["valore"]}</span></h3>
                        <h6 class=\"$classeColore\">{$elemento["etichetta"]}</h6>
                    </div>";
            }
        }
        
        function getJavascriptAssociato() {
            return "<script src=\"plugins/waypoints/jquery.waypoints.min.js\"></script>
                <script src=\"plugins/counterUp/jquery.counterup.min.js\"></script>
                <script>
                    jQuery(document).ready(function($) {
                        $('.counter').counterUp({
                                delay: 10,
                                time: 1000
                        });
                    });
                </script>";
        }
    }